/* ************************************************************************** */
/* Example of a syndication feed reader using the Project Rome API            */
/* current version of Rome: rome1.0.jar            https://rome.dev.java.net/ */
/* You need to implement this API plus the JDOM API                           */
/* jdom.jar  ,   you can find this at               https://jdom.org/         */
/* Parts of this example are taken from the PRome Web Page tutorials          */
/* https://rome.dev.java.net/ thanks to author:   Alejandro Abdelnur          */
/*                                                                            */
/* This program converts any syndication feed into a selected type            */
/* of feed, prints it to the screen and stores it to a file.                  */
/* created by Martin Stoppacher       date:  26.12.2009                       */
/* license:    LGPL 3.0                                                       */
/*             (Lesser Gnu Public License version 3.0),                       */
/*             cf. <http://www.gnu.org/licenses/lgpl.html>                    */
/* ************************************************************************** */ 
import java.net.URL;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;

import com.sun.syndication.feed.synd.SyndFeed;
/* This is the Bean interface for all types of feeds.                         */
import com.sun.syndication.io.SyndFeedInput;
/* Parses an XML document (File, InputStream, Reader, W3C SAX InputSource, W3C*/
/* DOM Document or JDom DOcument) into an WireFeed (RSS/Atom).                */
import com.sun.syndication.io.SyndFeedOutput;
/* Generates an XML document(String, File, OutputStream, Writer,              */
/* W3C DOM document or JDOM document)out of an SyndFeedImpl                   */
import com.sun.syndication.io.XmlReader;
/* Character stream that handles (or at least attemtps to) all the necessary  */
/* Voodo to figure out the charset encoding of the XML document within        */
/* the stream.                                                                */

public class 5_FeedConverter {
	
    public static void main(String[] args) {
        boolean ok = false;
        if (args.length==1) {
            try {
                String outputType = args[0];
                String fileName = outputType;
                URL feedUrl = new URL("http://rss.orf.at/fm4.xml");

                SyndFeedInput input = new SyndFeedInput();
                SyndFeed feed = input.build(new XmlReader(feedUrl));
                
                feed.setFeedType(outputType); 
                /*         this line converts the feed into a specific format */
                
                SyndFeedOutput output = new SyndFeedOutput();
                output.output(feed,new PrintWriter(System.out));
                
                /*                                       // optional writer part      
                Writer writer = new FileWriter(fileName);
                SyndFeedOutput output1 = new SyndFeedOutput();
                output1.output(feed,writer);
                writer.close();
                */
                    
                ok = true;
            }
            catch (Exception ex) {
                System.out.println("ERROR: "+ex.getMessage());
            }
        }

        if (!ok) {
            System.out.println();
            System.out.println("FeedConverter converts between syndication" 
                              +" feeds types.");
            System.out.println("The first parameter must be the feed type to"
                              +" convert to.");
            System.out.println(" [valid values are: rss_0.9, rss_0.91,"
                              +" rss_0.92, rss_0.93, ]");
            System.out.println(" [                  rss_0.94, rss_1.0," 
                              +" rss_2.0 & atom_0.3  ]");
            System.out.println();
        }
    }
}